-- RadarBars.
-- shows up when SSMusicInfo is set to RadarBars.

local percentLabelY = 96;

local rb = Def.ActorFrame{
	Name="RadarBars";
	InitCommand=cmd(x,-80);

	Def.ActorFrame{
		Name="Dividers";
		InitCommand=cmd(x,80;diffuse,color("0,0,0,1"));
		OnCommand=cmd(diffusealpha,0;linear,0.2;diffusealpha,0.075);
		OffCommand=cmd(linear,0.2;diffusealpha,0);

		Def.Quad{
			Name="Divider1";
			InitCommand=cmd(y,10;zoomto,294,2);
		};
		Def.Quad{
			Name="Divider2";
			InitCommand=cmd(y,30;zoomto,294,2);
		};
		Def.Quad{
			Name="Divider3";
			InitCommand=cmd(y,50;zoomto,294,2);
		};
		Def.Quad{
			Name="Divider4";
			InitCommand=cmd(y,70;zoomto,294,2);
		};
	};

	Def.ActorFrame{
		Name="CategoryLabels";

		AutoText("frutiger",true)..{
			InitCommand=cmd(shadowlength,0;zoom,0.5;diffuse,color("#000000");settext,THEME:GetString("RadarCategory","Stream");horizalign,right;strokecolor,color("0,0,0,0.1"));
		};

		AutoText("frutiger",true)..{
			InitCommand=cmd(y,20;shadowlength,0;zoom,0.5;diffuse,color("#000000");settext,THEME:GetString("RadarCategory","Voltage");horizalign,right;strokecolor,color("0,0,0,0.1"));
		};

		AutoText("frutiger",true)..{
			InitCommand=cmd(y,40;shadowlength,0;zoom,0.5;diffuse,color("#000000");settext,THEME:GetString("RadarCategory","Air");horizalign,right;strokecolor,color("0,0,0,0.1"));
		};

		AutoText("frutiger",true)..{
			InitCommand=cmd(y,60;shadowlength,0;zoom,0.5;diffuse,color("#000000");settext,THEME:GetString("RadarCategory","Freeze");horizalign,right;strokecolor,color("0,0,0,0.1"));
		};

		AutoText("frutiger",true)..{
			InitCommand=cmd(y,80;shadowlength,0;zoom,0.5;diffuse,color("#000000");settext,THEME:GetString("RadarCategory","Chaos");horizalign,right;strokecolor,color("0,0,0,0.1"));
		};
	};

	-- decorations
	Def.Quad{
		Name="RB_Background";
		InitCommand=cmd(zoomto,192,96;x,100;y,40);
		OnCommand=cmd(diffuse,color("0.5,0.5,0.5,0.5"));
	};
	Def.ActorFrame{
		InitCommand=cmd(x,8);

		AutoText("frutiger",true)..{
			InitCommand=cmd(y,percentLabelY;shadowlength,0;zoom,0.55;diffuse,color("#000000");settext,"0%";horizalign,left;strokecolor,color("0,0,0,0.1"));
		};

		Def.Quad{
			Name="RB_0";
			InitCommand=cmd(zoomto,2,92;y,40);
			OnCommand=cmd(diffuse,color("1,1,1,0.25"));
		};
	};
	Def.ActorFrame{
		InitCommand=cmd(x,96);

		AutoText("frutiger",true)..{
			InitCommand=cmd(y,percentLabelY;shadowlength,0;zoom,0.55;diffuse,color("#000000");settext,"50%";strokecolor,color("0,0,0,0.1"));
		};

		Def.Quad{
			Name="RB_50";
			InitCommand=cmd(zoomto,2,92;y,40);
			OnCommand=cmd(diffuse,color("1,1,1,0.25"));
		};
	};
	Def.ActorFrame{
		InitCommand=cmd(x,192);

		AutoText("frutiger",true)..{
			InitCommand=cmd(y,percentLabelY;shadowlength,0;zoom,0.55;diffuse,color("#000000");settext,"100%";horizalign,right;strokecolor,color("0,0,0,0.1"));
		};

		Def.Quad{
			Name="RB_100";
			InitCommand=cmd(zoomto,2,92;y,40);
			OnCommand=cmd(diffuse,color("1,1,1,0.25"));
		};
	};
};

-- the bars themselves have to be done here because there is some fuckery
-- involved in determining player shit

-- first get the number of active players. this determines bar size.
local numPlayers = GAMESTATE:GetNumPlayersEnabled();
local barSize = 12; -- default for a single player.
local bars = Def.ActorFrame{ }; -- bars!!
local rv;
local refreshRate = 0.03;

if numPlayers == 1 then
	-- make for 1p
	local player = GAMESTATE:GetMasterPlayerNumber();

	for idx, cat in pairs(RadarCategory) do
		if idx < 6 then
			bars[#bars+1] = Def.Quad{
				Name="RB_"..idx..player;
				InitCommand=function(self)
					self:diffuse(PlayerColor(player));
					self:diffusebottomedge(PlayerMidColor(player));
					self:x(8);
					self:y((idx-1)*20);
					self:horizalign(left);
					self:zoomy(barSize);
					self:playcommand("Set");
				end;

				SetCommand=function(self)
					local width;
					local song;
					local steps;
					if GAMESTATE:IsCourseMode() then
						song = GAMESTATE:GetCurrentCourse();
						steps = GAMESTATE:GetCurrentTrail(player);
					else
						song = GAMESTATE:GetCurrentSong();
						steps = GAMESTATE:GetCurrentSteps(player);
					end;
					if not song then
						width = 0;
					else
						if steps then
							rv = steps:GetRadarValues(player);
							width = rv:GetValue(cat) * 184;
						else width = 0;
						end;
					end;
					self:finishtweening();
					self:decelerate(refreshRate);
					self:zoomx(width);

					-- glow time
					if width == 184 then
						self:glowshift();
						self:effectcolor1( color("1,1,1,0") );
						self:effectcolor2( color("1,1,1,0.25") );
						self:effectperiod(1);
						self:effectclock("beatnooffset");
					else
						self:stopeffect();
					end;
				end;

				CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
				CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");

				CurrentStepsP1ChangedMessageCommand=function(self)
					if player == PLAYER_1 then
						self:playcommand("Set");
					end;
				end;
				CurrentTrailP1ChangedMessageCommand=function(self)
					if player == PLAYER_1 then
						self:playcommand("Set");
					end;
				end;
				CurrentStepsP2ChangedMessageCommand=function(self)
					if player == PLAYER_2 then
						self:playcommand("Set");
					end;
				end;
				CurrentTrailP2ChangedMessageCommand=function(self)
					if player == PLAYER_2 then
						self:playcommand("Set");
					end;
				end;
			};
		end;
	end;
elseif numPlayers == 2 then
	-- make for 2p
	barSize = barSize/2;

	for pi, pname in pairs(PlayerNumber) do
		for idx, cat in pairs(RadarCategory) do
			if idx < 6 then
				bars[#bars+1] = Def.Quad{
					Name="RB_"..idx..pname;
					InitCommand=function(self)
						self:diffuse(PlayerColor(pname));
						self:diffusebottomedge(PlayerMidColor(pname));
						self:x(8);
						self:y(((idx-1)*20)+((pi-1)*barSize)-2);
						self:horizalign(left);
						self:zoomy(barSize);
						self:playcommand("Set");
					end;

					SetCommand=function(self)
						local width;
						local song;
						local steps;
						if GAMESTATE:IsCourseMode() then
							song = GAMESTATE:GetCurrentCourse();
							steps = GAMESTATE:GetCurrentTrail(pname);
						else
							song = GAMESTATE:GetCurrentSong();
							steps = GAMESTATE:GetCurrentSteps(pname);
						end
						if not song then
							width = 0;
						else
							if steps then
								rv = steps:GetRadarValues(pname);
								width = rv:GetValue(cat) * 184;
							end;
						end;
						self:finishtweening();
						self:decelerate(refreshRate);
						self:zoomx(width);
					end;

					CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
					CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");

					CurrentStepsP1ChangedMessageCommand=function(self)
						if pname == PLAYER_1 then
							self:playcommand("Set");
						end;
					end;
					CurrentTrailP1ChangedMessageCommand=function(self)
						if pname == PLAYER_1 then
							self:playcommand("Set");
						end;
					end;
					CurrentStepsP2ChangedMessageCommand=function(self)
						if pname == PLAYER_2 then
							self:playcommand("Set");
						end;
					end;
					CurrentTrailP2ChangedMessageCommand=function(self)
						if pname == PLAYER_2 then
							self:playcommand("Set");
						end;
					end;
				};
			end;
		end;
	end;
end;

rb[#rb+1] = bars;

return rb;